/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.VCDiffCodeTableWriter;
import com.davidehrmann.vcdiff.engine.BlockHash;
import com.davidehrmann.vcdiff.engine.RollingHash;
import java.io.IOException;
import java.nio.ByteBuffer;

class VCDiffEngine {
    public static final int kMinimumMatchSize = 32;
    protected final byte[] dictionary_;
    protected final BlockHash hashed_dictionary_;

    public VCDiffEngine(byte[] dictionary) {
        this.dictionary_ = dictionary;
        this.hashed_dictionary_ = BlockHash.CreateDictionaryHash(this.dictionary_);
    }

    public int dictionary_size() {
        return this.dictionary_.length;
    }

    public <OUT> void Encode(ByteBuffer targetData, boolean lookForTargetMatches, OUT diff, VCDiffCodeTableWriter<OUT> coder) throws IOException {
        if (!targetData.hasRemaining()) {
            return;
        }
        if (targetData.remaining() < 16) {
            int target_size = targetData.remaining();
            this.AddUnmatchedRemainder(targetData, coder);
            coder.output(diff);
            return;
        }
        ByteBuffer local_target_data = targetData.slice();
        RollingHash hasher = new RollingHash(16);
        BlockHash target_hash = lookForTargetMatches ? BlockHash.CreateTargetHash(local_target_data.slice(), this.dictionary_size()) : null;
        ByteBuffer candidate_pos = local_target_data.slice();
        int hash_value = (int)hasher.Hash(candidate_pos.array(), candidate_pos.arrayOffset() + candidate_pos.position(), candidate_pos.remaining());
        while (true) {
            if (this.EncodeCopyForBestMatch(lookForTargetMatches, hash_value, candidate_pos, local_target_data, target_hash, coder)) {
                candidate_pos.position(local_target_data.position());
                if (candidate_pos.remaining() < 16) break;
                hash_value = (int)hasher.Hash(candidate_pos.array(), candidate_pos.arrayOffset() + candidate_pos.position(), candidate_pos.remaining());
                if (!lookForTargetMatches) continue;
                target_hash.AddAllBlocksThroughIndex(candidate_pos.position());
                continue;
            }
            if (candidate_pos.remaining() - 1 < 16) break;
            if (lookForTargetMatches) {
                target_hash.AddOneIndexHash(candidate_pos.position(), hash_value);
            }
            byte new_last_byte = candidate_pos.get(candidate_pos.position() + 16);
            byte old_first_byte = candidate_pos.get();
            hash_value = (int)hasher.UpdateHash(hash_value, old_first_byte, new_last_byte);
        }
        this.AddUnmatchedRemainder(local_target_data, coder);
        coder.output(diff);
        targetData.position(targetData.position() + local_target_data.position());
    }

    protected static boolean ShouldGenerateCopyInstructionForMatchOfSize(int size) {
        return size >= 32;
    }

    protected void AddUnmatchedRemainder(ByteBuffer unencoded_target, VCDiffCodeTableWriter<?> coder) {
        if (unencoded_target.hasRemaining()) {
            coder.add(unencoded_target.array(), unencoded_target.arrayOffset() + unencoded_target.position(), unencoded_target.remaining());
            unencoded_target.position(unencoded_target.limit());
        }
    }

    protected boolean EncodeCopyForBestMatch(boolean look_for_target_matches, int hash_value, ByteBuffer target_candidate, ByteBuffer unencoded_target, BlockHash target_hash, VCDiffCodeTableWriter<?> coder) {
        BlockHash.Match best_match = new BlockHash.Match();
        ByteBuffer target = unencoded_target.slice();
        target.position(target_candidate.arrayOffset() + target_candidate.position() - (unencoded_target.arrayOffset() + unencoded_target.position()));
        this.hashed_dictionary_.FindBestMatch(hash_value, target, best_match);
        if (look_for_target_matches) {
            target_hash.FindBestMatch(hash_value, target, best_match);
        }
        if (!VCDiffEngine.ShouldGenerateCopyInstructionForMatchOfSize(best_match.size())) {
            return false;
        }
        if (best_match.target_offset() > 0) {
            coder.add(unencoded_target.array(), unencoded_target.arrayOffset() + unencoded_target.position(), best_match.target_offset());
        }
        coder.copy(best_match.source_offset(), best_match.size());
        unencoded_target.position(unencoded_target.position() + best_match.target_offset() + best_match.size());
        return best_match.target_offset() + best_match.size() > 0;
    }
}

