/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.VCDiffCodeTableWriter;
import com.davidehrmann.vcdiff.VCDiffFormatExtension;
import com.davidehrmann.vcdiff.engine.VCDiffAddressCache;
import com.davidehrmann.vcdiff.engine.VCDiffAddressCacheImpl;
import com.davidehrmann.vcdiff.engine.VCDiffCodeTableData;
import com.davidehrmann.vcdiff.engine.VCDiffInstructionMap;
import com.davidehrmann.vcdiff.io.CountingOutputStream;
import com.davidehrmann.vcdiff.mina_buffer.IoBuffer;
import com.davidehrmann.vcdiff.util.VarInt;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCDiffCodeTableWriterImpl
implements VCDiffCodeTableWriter<OutputStream> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCDiffCodeTableWriterImpl.class);
    private static final byte[] HEADER_STANDARD_FORMAT = new byte[]{-42, -61, -60, 0, 0};
    private static final byte[] HEADER_EXTENDED_FORMAT = new byte[]{-42, -61, -60, 83, 0};
    static final int VCD_SOURCE = 1;
    static final int VCD_TARGET = 2;
    static final int VCD_CHECKSUM = 4;
    private final int maxMode;
    private IoBuffer instructionsAndSizes = IoBuffer.allocate(1024);
    private IoBuffer dataForAddAndRun;
    private final IoBuffer separateDataForAddAndRun = IoBuffer.allocate(1024);
    private IoBuffer addressesForCopy;
    private final IoBuffer separateAddressesForCopy = IoBuffer.allocate(1024);
    private final VCDiffAddressCache addraddressCachess_cache_;
    private int dictionarySize;
    private int targetLength;
    private final VCDiffCodeTableData codeTableData;
    private VCDiffInstructionMap instructionMap;
    private int lastOpcodeIndex;
    private boolean addChecksum;
    private long checksum;

    public VCDiffCodeTableWriterImpl(boolean interleaved) {
        this.maxMode = VCDiffAddressCache.DefaultLastMode();
        this.dictionarySize = 0;
        this.targetLength = 0;
        this.codeTableData = VCDiffCodeTableData.kDefaultCodeTableData;
        this.instructionMap = null;
        this.lastOpcodeIndex = -1;
        this.addChecksum = false;
        this.checksum = 0L;
        this.addraddressCachess_cache_ = new VCDiffAddressCacheImpl();
        this.instructionsAndSizes.setAutoExpand(true);
        this.separateDataForAddAndRun.setAutoExpand(true);
        this.separateAddressesForCopy.setAutoExpand(true);
        this.initSectionPointers(interleaved);
    }

    VCDiffCodeTableWriterImpl(boolean interleaved, short nearCacheSize, short sameCacheSize, VCDiffCodeTableData codeTableData, short maxMode) {
        this.addraddressCachess_cache_ = new VCDiffAddressCacheImpl(nearCacheSize, sameCacheSize);
        this.dictionarySize = 0;
        this.targetLength = 0;
        this.codeTableData = codeTableData;
        this.instructionMap = null;
        this.lastOpcodeIndex = -1;
        this.addChecksum = false;
        this.checksum = 0L;
        this.maxMode = maxMode;
        this.initSectionPointers(interleaved);
    }

    @Override
    public void init(int dictionarySize) {
        this.dictionarySize = dictionarySize;
        if (this.instructionMap == null) {
            this.instructionMap = this.codeTableData == VCDiffCodeTableData.kDefaultCodeTableData ? VCDiffInstructionMap.DEFAULT_INSTRUCTION_MAP : new VCDiffInstructionMap(this.codeTableData, (byte)this.maxMode);
        }
        this.addraddressCachess_cache_.Init();
        this.targetLength = 0;
        this.lastOpcodeIndex = -1;
    }

    @Override
    public void add(byte[] data, int offset, int length) {
        if (offset + length > data.length || length < 0) {
            throw new IllegalArgumentException();
        }
        this.encodeInstruction((byte)1, length);
        this.dataForAddAndRun.put(data, offset, length);
        this.targetLength += length;
    }

    @Override
    public void addChecksum(int checksum) {
        this.addChecksum = true;
        this.checksum = (long)checksum & 0xFFFFFFFFL;
    }

    @Override
    public void copy(int offset, int size) {
        if (this.instructionMap == null) {
            throw new IllegalStateException("copy called without calling init().");
        }
        AtomicInteger encoded_addr = new AtomicInteger(0);
        byte mode = (byte)this.addraddressCachess_cache_.EncodeAddress(offset, this.dictionarySize + this.targetLength, encoded_addr);
        this.encodeInstruction((byte)3, size, mode);
        if (this.addraddressCachess_cache_.WriteAddressAsVarintForMode(mode)) {
            this.addressesForCopy.expand(VarInt.calculateIntLength(encoded_addr.get()));
            VarInt.putInt(this.addressesForCopy.buf(), encoded_addr.get());
        } else {
            this.addressesForCopy.put((byte)encoded_addr.get());
        }
        this.targetLength += size;
    }

    @Override
    public void finishEncoding(OutputStream out) throws IOException {
    }

    public int getDeltaWindowSize() {
        int length_of_the_delta_encoding = this.calculateLengthOfTheDeltaEncoding();
        return length_of_the_delta_encoding + 1 + VarInt.calculateIntLength(this.dictionarySize) + VarInt.calculateIntLength(0) + VarInt.calculateIntLength(length_of_the_delta_encoding);
    }

    @Override
    public void output(OutputStream out) throws IOException {
        if (this.instructionsAndSizes.position() == 0) {
            LOGGER.warn("Empty input; no delta window produced");
        } else {
            CountingOutputStream countedOut = new CountingOutputStream(out);
            if (this.addChecksum) {
                countedOut.write(5);
            } else {
                countedOut.write(1);
            }
            VarInt.writeInt(countedOut, this.dictionarySize);
            VarInt.writeInt(countedOut, 0);
            int length_of_the_delta_encoding = this.calculateLengthOfTheDeltaEncoding();
            VarInt.writeInt(countedOut, length_of_the_delta_encoding);
            int size_before_delta_encoding = (int)countedOut.getBytesWritten();
            VarInt.writeInt(countedOut, this.targetLength);
            countedOut.write(0);
            VarInt.writeInt(countedOut, this.separateDataForAddAndRun.position());
            VarInt.writeInt(countedOut, this.instructionsAndSizes.position());
            VarInt.writeInt(countedOut, this.separateAddressesForCopy.position());
            if (this.addChecksum) {
                VarInt.writeLong(countedOut, this.checksum);
            }
            countedOut.write(this.separateDataForAddAndRun.array(), this.separateDataForAddAndRun.arrayOffset(), this.separateDataForAddAndRun.position());
            countedOut.write(this.instructionsAndSizes.array(), this.instructionsAndSizes.arrayOffset(), this.instructionsAndSizes.position());
            countedOut.write(this.separateAddressesForCopy.array(), this.separateAddressesForCopy.arrayOffset(), this.separateAddressesForCopy.position());
            int size_after_delta_encoding = (int)countedOut.getBytesWritten();
            if (length_of_the_delta_encoding != size_after_delta_encoding - size_before_delta_encoding) {
                throw new IllegalStateException(String.format("Internal error: calculated length of the delta encoding (%d) does not match actual length (%d)", length_of_the_delta_encoding, size_after_delta_encoding - size_before_delta_encoding));
            }
            this.separateDataForAddAndRun.clear();
            this.instructionsAndSizes.clear();
            this.separateAddressesForCopy.clear();
            if (this.targetLength == 0) {
                LOGGER.warn("Empty target window");
            }
        }
        this.init(this.dictionarySize);
    }

    @Override
    public void run(int size, byte b2) {
        this.encodeInstruction((byte)2, size);
        this.dataForAddAndRun.put(b2);
        this.targetLength += size;
    }

    @Override
    public void writeHeader(OutputStream out, EnumSet<VCDiffFormatExtension> formatExtensions) throws IOException {
        if (formatExtensions.isEmpty()) {
            out.write(HEADER_STANDARD_FORMAT);
        } else {
            out.write(HEADER_EXTENDED_FORMAT);
        }
    }

    public int targetLength() {
        return this.targetLength;
    }

    void initSectionPointers(boolean interleaved) {
        if (interleaved) {
            this.dataForAddAndRun = this.instructionsAndSizes;
            this.addressesForCopy = this.instructionsAndSizes;
        } else {
            this.dataForAddAndRun = this.separateDataForAddAndRun;
            this.addressesForCopy = this.separateAddressesForCopy;
        }
    }

    private void encodeInstruction(byte inst, int size, byte mode) {
        short opcode;
        if (this.instructionMap == null) {
            throw new IllegalStateException("encodeInstruction() called without calling init()");
        }
        if (this.lastOpcodeIndex >= 0) {
            short compound_opcode;
            byte last_opcode = this.instructionsAndSizes.get(this.lastOpcodeIndex);
            if (inst == 1 && this.codeTableData.inst1[last_opcode & 0xFF] == 1) {
                LOGGER.warn("encodeInstruction() called for two ADD instructions in a row");
            }
            if (size <= 255 && (compound_opcode = this.instructionMap.LookupSecondOpcode(last_opcode, inst, (byte)size, mode)) != 256) {
                this.instructionsAndSizes.put(this.lastOpcodeIndex, (byte)compound_opcode);
                this.lastOpcodeIndex = -1;
                return;
            }
            compound_opcode = this.instructionMap.LookupSecondOpcode(last_opcode, inst, (byte)0, mode);
            if (compound_opcode != 256) {
                this.instructionsAndSizes.put(this.lastOpcodeIndex, (byte)compound_opcode);
                this.lastOpcodeIndex = -1;
                this.instructionsAndSizes.expand(VarInt.calculateIntLength(size));
                VarInt.putInt(this.instructionsAndSizes.buf(), size);
                return;
            }
        }
        if (size <= 255 && (opcode = this.instructionMap.LookupFirstOpcode(inst, (byte)size, mode)) != 256) {
            this.instructionsAndSizes.put((byte)opcode);
            this.lastOpcodeIndex = this.instructionsAndSizes.position() - 1;
            return;
        }
        opcode = this.instructionMap.LookupFirstOpcode(inst, (byte)0, mode);
        if (opcode == 256) {
            throw new IllegalStateException(String.format("No matching opcode found for inst %d, mode %d, size 0", inst, mode));
        }
        this.instructionsAndSizes.put((byte)opcode);
        this.lastOpcodeIndex = this.instructionsAndSizes.position() - 1;
        this.instructionsAndSizes.expand(VarInt.calculateIntLength(size));
        VarInt.putInt(this.instructionsAndSizes.buf(), size);
    }

    private void encodeInstruction(byte inst, int size) {
        this.encodeInstruction(inst, size, (byte)0);
    }

    private int calculateLengthOfTheDeltaEncoding() {
        int length_of_the_delta_encoding = VarInt.calculateIntLength(this.targetLength) + 1 + VarInt.calculateIntLength(this.separateDataForAddAndRun.position()) + VarInt.calculateIntLength(this.instructionsAndSizes.position()) + VarInt.calculateIntLength(this.separateAddressesForCopy.position()) + this.separateDataForAddAndRun.position() + this.instructionsAndSizes.position() + this.separateAddressesForCopy.position();
        if (this.addChecksum) {
            length_of_the_delta_encoding += VarInt.calculateLongLength(this.checksum);
        }
        return length_of_the_delta_encoding;
    }
}

