/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

abstract class VCDiffAddressCache {
    public static final short VCD_SELF_MODE = 0;
    public static final short VCD_HERE_MODE = 1;
    public static final short VCD_FIRST_NEAR_MODE = 2;
    public static final short VCD_MAX_MODES = 256;
    static final short kDefaultNearCacheSize = 4;
    static final short kDefaultSameCacheSize = 3;
    static final int RESULT_END_OF_DATA = -2;
    int next_slot_;
    final int[] near_addresses_;
    final int[] same_addresses_;

    protected VCDiffAddressCache() {
        this(4, 3);
    }

    protected VCDiffAddressCache(short near_cache_size, short same_cache_size) {
        if (near_cache_size > 254 || near_cache_size < 0) {
            throw new IllegalArgumentException("Near cache size " + near_cache_size + " is invalid");
        }
        if (same_cache_size > 254 || same_cache_size < 0) {
            throw new IllegalArgumentException("Same cache size " + same_cache_size + " is invalid");
        }
        if (near_cache_size + same_cache_size > 254) {
            throw new IllegalArgumentException("Using near cache size " + near_cache_size + " and same cache size " + same_cache_size + " would exceed maximum number of COPY modes (" + 256);
        }
        this.near_addresses_ = new int[near_cache_size];
        this.same_addresses_ = new int[same_cache_size * 256];
    }

    public abstract void Init();

    public short FirstSameMode() {
        return (short)(2 + this.near_addresses_.length);
    }

    public short LastMode() {
        return (byte)(this.FirstSameMode() + this.same_addresses_.length / 256 - 1);
    }

    static byte DefaultLastMode() {
        return 8;
    }

    static boolean IsSelfMode(short mode) {
        return mode == 0;
    }

    static boolean IsHereMode(short mode) {
        return mode == 1;
    }

    boolean IsNearMode(short mode) {
        return mode >= 2 && mode < this.FirstSameMode();
    }

    boolean IsSameMode(short mode) {
        return mode >= this.FirstSameMode() && mode <= this.LastMode();
    }

    static int DecodeSelfAddress(int encoded_address) {
        return encoded_address;
    }

    static int DecodeHereAddress(int encoded_address, int here_address) {
        return here_address - encoded_address;
    }

    int DecodeNearAddress(short mode, int encoded_address) {
        return this.near_addresses_[mode - 2] + encoded_address;
    }

    public final int DecodeSameAddress(short mode, short encoded_address) {
        return this.same_addresses_[(mode - this.FirstSameMode()) * 256 + encoded_address];
    }

    public final boolean WriteAddressAsVarintForMode(short mode) {
        return !this.IsSameMode(mode);
    }

    public abstract void UpdateCache(int var1);

    public abstract short EncodeAddress(int var1, int var2, AtomicInteger var3);

    public abstract int DecodeAddress(int var1, short var2, ByteBuffer var3) throws IOException;
}

