/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff;

import com.davidehrmann.vcdiff.VCDiffEncoder;
import com.davidehrmann.vcdiff.VCDiffFormatExtension;
import com.davidehrmann.vcdiff.VCDiffStreamingEncoder;
import com.davidehrmann.vcdiff.engine.HashedDictionary;
import com.davidehrmann.vcdiff.engine.JSONCodeTableWriter;
import com.davidehrmann.vcdiff.engine.VCDiffCodeTableWriterImpl;
import com.davidehrmann.vcdiff.engine.VCDiffStreamingEncoderImpl;
import com.davidehrmann.vcdiff.io.VCDiffOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;

public class VCDiffEncoderBuilder {
    protected boolean interleaved = false;
    protected boolean checksum = false;
    protected boolean targetMatches = true;
    protected byte[] dictionary = null;

    protected VCDiffEncoderBuilder() {
    }

    public synchronized VCDiffEncoderBuilder withChecksum(boolean checksum) {
        this.checksum = checksum;
        return this;
    }

    public synchronized VCDiffEncoderBuilder withInterleaving(boolean interleaved) {
        this.interleaved = interleaved;
        return this;
    }

    public synchronized VCDiffEncoderBuilder withDictionary(byte[] dictionary) {
        this.dictionary = dictionary;
        return this;
    }

    public synchronized VCDiffEncoderBuilder withTargetMatches(boolean targetMatches) {
        this.targetMatches = targetMatches;
        return this;
    }

    public synchronized VCDiffStreamingEncoder<OutputStream> buildStreaming() {
        if (this.dictionary == null) {
            throw new IllegalArgumentException("dictionary not set");
        }
        EnumSet<VCDiffFormatExtension> formatFlags = EnumSet.noneOf(VCDiffFormatExtension.class);
        if (this.interleaved) {
            formatFlags.add(VCDiffFormatExtension.GOOGLE_INTERLEAVED);
        }
        if (this.checksum) {
            formatFlags.add(VCDiffFormatExtension.GOOGLE_CHECKSUM);
        }
        VCDiffCodeTableWriterImpl coder = new VCDiffCodeTableWriterImpl(this.interleaved);
        return new VCDiffStreamingEncoderImpl<OutputStream>(coder, new HashedDictionary(this.dictionary), formatFlags, this.targetMatches);
    }

    public VCDiffOutputStream buildOutputStream(OutputStream out) {
        return new VCDiffOutputStream(out, this.buildStreaming());
    }

    public synchronized VCDiffStreamingEncoder<Appendable> buildStreamingJson() {
        if (this.dictionary == null) {
            throw new IllegalArgumentException("dictionary not set");
        }
        if (this.interleaved) {
            throw new IllegalArgumentException("Interleaved not supported with JSON encoder");
        }
        if (this.checksum) {
            throw new IllegalArgumentException("Checksum not supported with JSON encoder");
        }
        JSONCodeTableWriter coder = new JSONCodeTableWriter();
        return new VCDiffStreamingEncoderImpl<Appendable>(coder, new HashedDictionary(this.dictionary), EnumSet.noneOf(VCDiffFormatExtension.class), this.targetMatches);
    }

    public VCDiffEncoder<OutputStream> buildSimple() {
        return new VCDiffEncoder<OutputStream>(this.buildStreaming());
    }

    public VCDiffEncoder<Appendable> buildSimpleJson() {
        return new VCDiffEncoder<Appendable>(this.buildStreamingJson());
    }

    public static VCDiffEncoderBuilder builder() {
        return new VCDiffEncoderBuilder();
    }
}

