/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff;

import com.davidehrmann.vcdiff.VCDiffStreamingEncoder;
import com.davidehrmann.vcdiff.util.Objects;
import java.io.IOException;

public class VCDiffEncoder<OUT> {
    private final VCDiffStreamingEncoder<OUT> encoder;

    public VCDiffEncoder(VCDiffStreamingEncoder<OUT> streamingEncoder) {
        this.encoder = Objects.requireNotNull(streamingEncoder, "encoder was null");
    }

    public void encode(byte[] data, int offset, int length, OUT out) throws IOException {
        this.encoder.startEncoding(out);
        this.encoder.encodeChunk(data, offset, length, out);
        this.encoder.finishEncoding(out);
    }

    public void encode(byte[] data, OUT out) throws IOException {
        this.encode(data, 0, data.length, out);
    }
}

