/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.DirectBufferAccess;
import sun.misc.Unsafe;

public class MessageBuffer {
    static final boolean isUniversalBuffer;
    static final Unsafe unsafe;
    private static final Constructor<?> mbArrConstructor;
    private static final Constructor<?> mbBBConstructor;
    static final int ARRAY_BYTE_BASE_OFFSET;
    private static final String UNIVERSAL_MESSAGE_BUFFER = "org.msgpack.core.buffer.MessageBufferU";
    private static final String BIGENDIAN_MESSAGE_BUFFER = "org.msgpack.core.buffer.MessageBufferBE";
    private static final String DEFAULT_MESSAGE_BUFFER = "org.msgpack.core.buffer.MessageBuffer";
    protected final Object base;
    protected final long address;
    protected final int size;
    protected final ByteBuffer reference;

    public static MessageBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("size must not be negative");
        }
        return MessageBuffer.wrap(new byte[n2]);
    }

    public static MessageBuffer wrap(byte[] byArray) {
        return MessageBuffer.newMessageBuffer(byArray, 0, byArray.length);
    }

    public static MessageBuffer wrap(byte[] byArray, int n2, int n3) {
        return MessageBuffer.newMessageBuffer(byArray, n2, n3);
    }

    public static MessageBuffer wrap(ByteBuffer byteBuffer) {
        return MessageBuffer.newMessageBuffer(byteBuffer);
    }

    private static MessageBuffer newMessageBuffer(byte[] byArray, int n2, int n3) {
        Preconditions.checkNotNull(byArray);
        return MessageBuffer.newInstance(mbArrConstructor, byArray, n2, n3);
    }

    private static MessageBuffer newMessageBuffer(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull(byteBuffer);
        return MessageBuffer.newInstance(mbBBConstructor, byteBuffer);
    }

    private static MessageBuffer newInstance(Constructor<?> constructor, Object ... objectArray) {
        try {
            return (MessageBuffer)constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            throw new IllegalStateException(invocationTargetException.getCause());
        }
    }

    public static void releaseBuffer(MessageBuffer messageBuffer) {
        if (!isUniversalBuffer && !messageBuffer.hasArray()) {
            if (DirectBufferAccess.isDirectByteBufferInstance(messageBuffer.reference)) {
                DirectBufferAccess.clean(messageBuffer.reference);
            } else {
                unsafe.freeMemory(messageBuffer.address);
            }
        }
    }

    MessageBuffer(byte[] byArray, int n2, int n3) {
        this.base = byArray;
        this.address = ARRAY_BYTE_BASE_OFFSET + n2;
        this.size = n3;
        this.reference = null;
    }

    MessageBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            if (isUniversalBuffer) {
                throw new UnsupportedOperationException("Cannot create MessageBuffer from a DirectBuffer on this platform");
            }
            this.base = null;
            this.address = DirectBufferAccess.getAddress(byteBuffer) + (long)byteBuffer.position();
            this.size = byteBuffer.remaining();
            this.reference = byteBuffer;
        } else if (byteBuffer.hasArray()) {
            this.base = byteBuffer.array();
            this.address = ARRAY_BYTE_BASE_OFFSET + byteBuffer.arrayOffset() + byteBuffer.position();
            this.size = byteBuffer.remaining();
            this.reference = null;
        } else {
            throw new IllegalArgumentException("Only the array-backed ByteBuffer or DirectBuffer is supported");
        }
    }

    protected MessageBuffer(Object object, long l2, int n2) {
        this.base = object;
        this.address = l2;
        this.size = n2;
        this.reference = null;
    }

    public int size() {
        return this.size;
    }

    public MessageBuffer slice(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        Preconditions.checkArgument(n2 + n3 <= this.size());
        return new MessageBuffer(this.base, this.address + (long)n2, n3);
    }

    public byte getByte(int n2) {
        return unsafe.getByte(this.base, this.address + (long)n2);
    }

    public boolean getBoolean(int n2) {
        return unsafe.getBoolean(this.base, this.address + (long)n2);
    }

    public short getShort(int n2) {
        short s2 = unsafe.getShort(this.base, this.address + (long)n2);
        return Short.reverseBytes(s2);
    }

    public int getInt(int n2) {
        int n3 = unsafe.getInt(this.base, this.address + (long)n2);
        return Integer.reverseBytes(n3);
    }

    public float getFloat(int n2) {
        return Float.intBitsToFloat(this.getInt(n2));
    }

    public long getLong(int n2) {
        long l2 = unsafe.getLong(this.base, this.address + (long)n2);
        return Long.reverseBytes(l2);
    }

    public double getDouble(int n2) {
        return Double.longBitsToDouble(this.getLong(n2));
    }

    public void getBytes(int n2, byte[] byArray, int n3, int n4) {
        unsafe.copyMemory(this.base, this.address + (long)n2, byArray, ARRAY_BYTE_BASE_OFFSET + n3, n4);
    }

    public void getBytes(int n2, int n3, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < n3) {
            throw new BufferOverflowException();
        }
        ByteBuffer byteBuffer2 = this.sliceAsByteBuffer(n2, n3);
        byteBuffer.put(byteBuffer2);
    }

    public void putByte(int n2, byte by) {
        unsafe.putByte(this.base, this.address + (long)n2, by);
    }

    public void putBoolean(int n2, boolean bl) {
        unsafe.putBoolean(this.base, this.address + (long)n2, bl);
    }

    public void putShort(int n2, short s2) {
        s2 = Short.reverseBytes(s2);
        unsafe.putShort(this.base, this.address + (long)n2, s2);
    }

    public void putInt(int n2, int n3) {
        n3 = Integer.reverseBytes(n3);
        unsafe.putInt(this.base, this.address + (long)n2, n3);
    }

    public void putFloat(int n2, float f2) {
        this.putInt(n2, Float.floatToRawIntBits(f2));
    }

    public void putLong(int n2, long l2) {
        l2 = Long.reverseBytes(l2);
        unsafe.putLong(this.base, this.address + (long)n2, l2);
    }

    public void putDouble(int n2, double d2) {
        this.putLong(n2, Double.doubleToRawLongBits(d2));
    }

    public void putBytes(int n2, byte[] byArray, int n3, int n4) {
        unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + n3, this.base, this.address + (long)n2, n4);
    }

    public void putByteBuffer(int n2, ByteBuffer byteBuffer, int n3) {
        assert (n3 <= byteBuffer.remaining());
        assert (!isUniversalBuffer);
        if (byteBuffer.isDirect()) {
            unsafe.copyMemory(null, DirectBufferAccess.getAddress(byteBuffer) + (long)byteBuffer.position(), this.base, this.address + (long)n2, n3);
            byteBuffer.position(byteBuffer.position() + n3);
        } else if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + byteBuffer.position(), this.base, this.address + (long)n2, n3);
            byteBuffer.position(byteBuffer.position() + n3);
        } else if (this.hasArray()) {
            byteBuffer.get((byte[])this.base, n2, n3);
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                unsafe.putByte(this.base, this.address + (long)n2, byteBuffer.get());
            }
        }
    }

    public void putMessageBuffer(int n2, MessageBuffer messageBuffer, int n3, int n4) {
        unsafe.copyMemory(messageBuffer.base, messageBuffer.address + (long)n3, this.base, this.address + (long)n2, n4);
    }

    public ByteBuffer sliceAsByteBuffer(int n2, int n3) {
        if (this.hasArray()) {
            return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)ARRAY_BYTE_BASE_OFFSET + (long)n2), n3);
        }
        assert (!isUniversalBuffer);
        return DirectBufferAccess.newByteBuffer(this.address, n2, n3, this.reference);
    }

    public ByteBuffer sliceAsByteBuffer() {
        return this.sliceAsByteBuffer(0, this.size());
    }

    public boolean hasArray() {
        return this.base != null;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        unsafe.copyMemory(this.base, this.address, byArray, ARRAY_BYTE_BASE_OFFSET, this.size());
        return byArray;
    }

    public byte[] array() {
        return (byte[])this.base;
    }

    public int arrayOffset() {
        return (int)this.address - ARRAY_BYTE_BASE_OFFSET;
    }

    public void copyTo(int n2, MessageBuffer messageBuffer, int n3, int n4) {
        unsafe.copyMemory(this.base, this.address + (long)n2, messageBuffer.base, messageBuffer.address + (long)n3, n4);
    }

    public String toHexString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 != n2) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%02x", this.getByte(i2)));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        String string;
        int n2;
        Unsafe unsafe;
        boolean bl;
        block21: {
            int n3;
            block20: {
                int n4;
                bl = false;
                unsafe = null;
                n2 = 16;
                string = System.getProperty("java.specification.version", "");
                n3 = string.indexOf(46);
                boolean bl2 = false;
                if (n3 != -1) {
                    try {
                        n4 = Integer.parseInt(string.substring(0, n3));
                        int n5 = Integer.parseInt(string.substring(n3 + 1));
                        bl2 = n4 > 1 || n4 == 1 && n5 >= 7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace(System.err);
                    }
                }
                n4 = 0;
                try {
                    n4 = Class.forName("sun.misc.Unsafe") != null ? 1 : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl3 = System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
                boolean bl4 = System.getProperty("com.google.appengine.runtime.version") != null;
                boolean bl5 = bl = Boolean.parseBoolean(System.getProperty("msgpack.universal-buffer", "false")) || bl3 || bl4 || !bl2 || n4 == 0;
                if (!bl) {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    unsafe = (Unsafe)field.get(null);
                    if (unsafe == null) {
                        throw new RuntimeException("Unsafe is unavailable");
                    }
                    n2 = unsafe.arrayBaseOffset(byte[].class);
                    int n6 = unsafe.arrayIndexScale(byte[].class);
                    if (n6 != 1) {
                        throw new IllegalStateException("Byte array index scale must be 1, but is " + n6);
                    }
                }
                MessageBuffer.unsafe = unsafe;
                ARRAY_BYTE_BASE_OFFSET = n2;
                isUniversalBuffer = bl;
                if (!isUniversalBuffer) break block20;
                string = UNIVERSAL_MESSAGE_BUFFER;
                break block21;
            }
            n3 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0;
            string = n3 != 0 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
            mbArrConstructor = constructor;
            Constructor<?> constructor2 = clazz.getDeclaredConstructor(ByteBuffer.class);
            constructor2.setAccessible(true);
            mbBBConstructor = constructor2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException(exception);
        }
        catch (Exception exception) {
            String string2;
            block22: {
                try {
                    exception.printStackTrace(System.err);
                    bl = true;
                    MessageBuffer.unsafe = unsafe;
                    ARRAY_BYTE_BASE_OFFSET = n2;
                    isUniversalBuffer = bl;
                    if (!isUniversalBuffer) break block22;
                    string2 = UNIVERSAL_MESSAGE_BUFFER;
                }
                catch (Throwable throwable) {
                    String string3;
                    MessageBuffer.unsafe = unsafe;
                    ARRAY_BYTE_BASE_OFFSET = n2;
                    isUniversalBuffer = bl;
                    if (isUniversalBuffer) {
                        string3 = UNIVERSAL_MESSAGE_BUFFER;
                    } else {
                        boolean bl6 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
                        string3 = bl6 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
                    }
                    try {
                        Class<?> clazz = Class.forName(string3);
                        Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
                        constructor.setAccessible(true);
                        mbArrConstructor = constructor;
                        Constructor<?> constructor3 = clazz.getDeclaredConstructor(ByteBuffer.class);
                        constructor3.setAccessible(true);
                        mbBBConstructor = constructor3;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace(System.err);
                        throw new RuntimeException(exception2);
                    }
                    throw throwable;
                }
            }
            boolean bl7 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
            string2 = bl7 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
                constructor.setAccessible(true);
                mbArrConstructor = constructor;
                Constructor<?> constructor4 = clazz.getDeclaredConstructor(ByteBuffer.class);
                constructor4.setAccessible(true);
                mbBBConstructor = constructor4;
            }
            catch (Exception exception3) {
                exception3.printStackTrace(System.err);
                throw new RuntimeException(exception3);
            }
        }
    }
}

