/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;

public class ChannelBufferOutput
implements MessageBufferOutput {
    private WritableByteChannel channel;
    private MessageBuffer buffer;

    public ChannelBufferOutput(WritableByteChannel writableByteChannel) {
        this(writableByteChannel, 8192);
    }

    public ChannelBufferOutput(WritableByteChannel writableByteChannel, int n2) {
        this.channel = Preconditions.checkNotNull(writableByteChannel, "output channel is null");
        this.buffer = MessageBuffer.allocate(n2);
    }

    public WritableByteChannel reset(WritableByteChannel writableByteChannel) throws IOException {
        WritableByteChannel writableByteChannel2 = this.channel;
        this.channel = writableByteChannel;
        return writableByteChannel2;
    }

    @Override
    public MessageBuffer next(int n2) throws IOException {
        if (this.buffer.size() < n2) {
            this.buffer = MessageBuffer.allocate(n2);
        }
        return this.buffer;
    }

    @Override
    public void writeBuffer(int n2) throws IOException {
        ByteBuffer byteBuffer = this.buffer.sliceAsByteBuffer(0, n2);
        while (byteBuffer.hasRemaining()) {
            this.channel.write(byteBuffer);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        while (byteBuffer.hasRemaining()) {
            this.channel.write(byteBuffer);
        }
    }

    @Override
    public void add(byte[] byArray, int n2, int n3) throws IOException {
        this.write(byArray, n2, n3);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void flush() throws IOException {
    }
}

