/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.BCException;

public class SimpleAnnotationValue
extends AnnotationValue {
    private byte theByte;
    private char theChar;
    private int theInt;
    private String theString;
    private double theDouble;
    private float theFloat;
    private long theLong;
    private short theShort;
    private boolean theBoolean;

    public SimpleAnnotationValue(int kind) {
        super(kind);
    }

    public SimpleAnnotationValue(int kind, Object value) {
        super(kind);
        switch (kind) {
            case 66: {
                this.theByte = (Byte)value;
                break;
            }
            case 67: {
                this.theChar = ((Character)value).charValue();
                break;
            }
            case 73: {
                this.theInt = (Integer)value;
                break;
            }
            case 115: {
                this.theString = (String)value;
                break;
            }
            case 68: {
                this.theDouble = (Double)value;
                break;
            }
            case 70: {
                this.theFloat = ((Float)value).floatValue();
                break;
            }
            case 74: {
                this.theLong = (Long)value;
                break;
            }
            case 83: {
                this.theShort = (Short)value;
                break;
            }
            case 90: {
                this.theBoolean = (Boolean)value;
                break;
            }
            default: {
                throw new BCException("Not implemented for this kind: " + SimpleAnnotationValue.whatKindIsThis(kind));
            }
        }
    }

    public void setValueString(String s2) {
        this.theString = s2;
    }

    public void setValueByte(byte b2) {
        this.theByte = b2;
    }

    public void setValueChar(char c2) {
        this.theChar = c2;
    }

    public void setValueInt(int i2) {
        this.theInt = i2;
    }

    @Override
    public String stringify() {
        switch (this.valueKind) {
            case 66: {
                return Byte.toString(this.theByte);
            }
            case 67: {
                return Character.toString(this.theChar);
            }
            case 68: {
                return Double.toString(this.theDouble);
            }
            case 70: {
                return Float.toString(this.theFloat);
            }
            case 73: {
                return Integer.toString(this.theInt);
            }
            case 74: {
                return Long.toString(this.theLong);
            }
            case 83: {
                return Short.toString(this.theShort);
            }
            case 90: {
                return Boolean.valueOf(this.theBoolean).toString();
            }
            case 115: {
                return this.theString;
            }
        }
        throw new BCException("Do not understand this kind: " + this.valueKind);
    }

    public String toString() {
        return this.stringify();
    }
}

