/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.aspectj.bridge.ICommand;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;

public class ReflectionFactory {
    public static final String OLD_AJC = "bridge.tools.impl.OldAjc";
    public static final String ECLIPSE = "org.aspectj.ajdt.ajc.AjdtCommand";
    private static final Object[] NONE = new Object[0];

    public static ICommand makeCommand(String cname, IMessageHandler errorSink) {
        return (ICommand)ReflectionFactory.make(ICommand.class, cname, NONE, errorSink);
    }

    private static Object make(Class<?> c2, String cname, Object[] args2, IMessageHandler errorSink) {
        Object result;
        block10: {
            boolean makeErrors = null != errorSink;
            result = null;
            try {
                Class<?> cfn = Class.forName(cname);
                String error = null;
                if (args2 == NONE) {
                    result = cfn.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    Class<?>[] types = ReflectionFactory.getTypes(args2);
                    Constructor<?> constructor = cfn.getConstructor(types);
                    if (null != constructor) {
                        result = constructor.newInstance(args2);
                    } else if (makeErrors) {
                        error = "no constructor for " + c2 + " using " + Arrays.asList(types);
                    }
                }
                if (null != result && !c2.isAssignableFrom(result.getClass())) {
                    if (makeErrors) {
                        error = "expecting type " + c2 + " got " + result.getClass();
                    }
                    result = null;
                }
                if (null != error) {
                    Message mssg = new Message(error, IMessage.FAIL, null, null);
                    errorSink.handleMessage(mssg);
                }
            }
            catch (Throwable t2) {
                if (!makeErrors) break block10;
                String mssg = "ReflectionFactory unable to load " + cname + " as " + c2.getName();
                Message m4 = new Message(mssg, IMessage.FAIL, t2, null);
                errorSink.handleMessage(m4);
            }
        }
        return result;
    }

    private static Class<?>[] getTypes(Object[] args2) {
        if (null == args2 || 0 < args2.length) {
            return new Class[0];
        }
        Class[] result = new Class[args2.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            if (null == args2[i2]) continue;
            result[i2] = args2[i2].getClass();
        }
        return result;
    }

    private ReflectionFactory() {
    }
}

