/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LineNumber;

public final class LineNumberTable
extends Attribute {
    private boolean isInPackedState = false;
    private byte[] data;
    private int tableLength;
    private LineNumber[] table;

    public LineNumberTable(LineNumberTable c2) {
        this(c2.getNameIndex(), c2.getLength(), c2.getLineNumberTable(), c2.getConstantPool());
    }

    public LineNumberTable(int nameIndex, int length, LineNumber[] lineNumberTable, ConstantPool constantPool) {
        super((byte)4, nameIndex, length, constantPool);
        this.setLineNumberTable(lineNumberTable);
        this.isInPackedState = false;
    }

    LineNumberTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LineNumber[])null, constant_pool);
        this.data = new byte[length];
        file.readFully(this.data);
        this.isInPackedState = true;
    }

    private void unpack() {
        if (this.isInPackedState) {
            try {
                ByteArrayInputStream bs = new ByteArrayInputStream(this.data);
                DataInputStream dis = new DataInputStream(bs);
                this.tableLength = dis.readUnsignedShort();
                this.table = new LineNumber[this.tableLength];
                for (int i2 = 0; i2 < this.tableLength; ++i2) {
                    this.table[i2] = new LineNumber(dis);
                }
                dis.close();
                this.data = null;
            }
            catch (IOException e2) {
                throw new RuntimeException("Unpacking of LineNumberTable attribute failed");
            }
            this.isInPackedState = false;
        }
    }

    @Override
    public void accept(ClassVisitor v2) {
        this.unpack();
        v2.visitLineNumberTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (this.isInPackedState) {
            file.write(this.data);
        } else {
            file.writeShort(this.tableLength);
            for (int i2 = 0; i2 < this.tableLength; ++i2) {
                this.table[i2].dump(file);
            }
        }
    }

    public final LineNumber[] getLineNumberTable() {
        this.unpack();
        return this.table;
    }

    public final void setLineNumberTable(LineNumber[] line_number_table) {
        this.data = null;
        this.isInPackedState = false;
        this.table = line_number_table;
        this.tableLength = line_number_table == null ? 0 : line_number_table.length;
    }

    @Override
    public final String toString() {
        this.unpack();
        StringBuffer buf = new StringBuffer();
        StringBuffer line = new StringBuffer();
        for (int i2 = 0; i2 < this.tableLength; ++i2) {
            line.append(this.table[i2].toString());
            if (i2 < this.tableLength - 1) {
                line.append(", ");
            }
            if (line.length() <= 72) continue;
            line.append('\n');
            buf.append(line);
            line.setLength(0);
        }
        buf.append(line);
        return buf.toString();
    }

    public int getSourceLine(int pos) {
        this.unpack();
        int l2 = 0;
        int r2 = this.tableLength - 1;
        if (r2 < 0) {
            return -1;
        }
        int min_index = -1;
        int min2 = -1;
        do {
            int i2;
            int j2;
            if ((j2 = this.table[i2 = (l2 + r2) / 2].getStartPC()) == pos) {
                return this.table[i2].getLineNumber();
            }
            if (pos < j2) {
                r2 = i2 - 1;
            } else {
                l2 = i2 + 1;
            }
            if (j2 >= pos || j2 <= min2) continue;
            min2 = j2;
            min_index = i2;
        } while (l2 <= r2);
        if (min_index < 0) {
            return -1;
        }
        return this.table[min_index].getLineNumber();
    }

    public final int getTableLength() {
        this.unpack();
        return this.tableLength;
    }
}

