/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.SummaryClientIdCounts;
import io.ably.lib.types.SummaryClientIdList;
import io.ably.lib.types.SummaryTotal;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class Summary {
    private static final String TAG = Summary.class.getName();
    private final Map<String, JsonObject> typeToSummaryJson;

    public Summary(Map<String, JsonObject> typeToSummaryJson) {
        this.typeToSummaryJson = typeToSummaryJson;
    }

    public static Map<String, SummaryClientIdList> asSummaryDistinctV1(JsonObject jsonObject) {
        HashMap<String, SummaryClientIdList> summary = new HashMap<String, SummaryClientIdList>();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            String key = entry.getKey();
            summary.put(key, Summary.asSummaryFlagV1(entry.getValue().getAsJsonObject()));
        }
        return summary;
    }

    public static Map<String, SummaryClientIdList> asSummaryUniqueV1(JsonObject jsonObject) {
        return Summary.asSummaryDistinctV1(jsonObject);
    }

    public static Map<String, SummaryClientIdCounts> asSummaryMultipleV1(JsonObject jsonObject) {
        HashMap<String, SummaryClientIdCounts> summary = new HashMap<String, SummaryClientIdCounts>();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            String key = entry.getKey();
            JsonObject value = entry.getValue().getAsJsonObject();
            int total = value.get("total").getAsInt();
            HashMap<String, Integer> clientIds = new HashMap<String, Integer>();
            for (Map.Entry<String, JsonElement> clientEntry : value.get("clientIds").getAsJsonObject().entrySet()) {
                clientIds.put(clientEntry.getKey(), clientEntry.getValue().getAsInt());
            }
            summary.put(key, new SummaryClientIdCounts(total, clientIds));
        }
        return summary;
    }

    public static SummaryClientIdList asSummaryFlagV1(JsonObject jsonObject) {
        int total = jsonObject.get("total").getAsInt();
        List clientIds = Serialisation.gson.fromJson(jsonObject.get("clientIds"), List.class);
        return new SummaryClientIdList(total, clientIds);
    }

    public static SummaryTotal asSummaryTotalV1(JsonObject jsonObject) {
        int total = jsonObject.get("total").getAsInt();
        return new SummaryTotal(total);
    }

    static Summary read(MessageUnpacker unpacker) {
        try {
            return Summary.read(Serialisation.msgpackToGson(unpacker.unpackValue()));
        }
        catch (Exception e2) {
            Log.e(TAG, "Failed to read summary from MessagePack", e2);
            return null;
        }
    }

    static Summary read(JsonElement json) {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected an object but got \"" + json.getClass() + "\".");
        }
        HashMap<String, JsonObject> typeToSummaryJson = new HashMap<String, JsonObject>();
        for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
            if (!entry.getValue().isJsonObject()) {
                throw new JsonParseException("Expected an object but got \"" + json.getClass() + "\".");
            }
            typeToSummaryJson.put(entry.getKey(), entry.getValue().getAsJsonObject());
        }
        return new Summary(typeToSummaryJson);
    }

    public JsonObject get(String annotationType) {
        return this.typeToSummaryJson.get(annotationType);
    }

    void write(MessagePacker packer) {
        Serialisation.gsonToMsgpack(this.toJsonTree(), packer);
    }

    JsonElement toJsonTree() {
        return Serialisation.gson.toJsonTree(this);
    }

    public static class Serializer
    implements JsonSerializer<Summary>,
    JsonDeserializer<Summary> {
        @Override
        public JsonElement serialize(Summary summary, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : summary.typeToSummaryJson.entrySet()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return json;
        }

        @Override
        public Summary deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Summary.read(json);
        }
    }
}

