/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonSyntaxException;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.util.HashMap;
import java.util.Map;

public class RecoveryKeyContext {
    private static final String TAG = "RecoveryKeyContext";
    private final String connectionKey;
    private final long msgSerial;
    private final Map<String, String> channelSerials = new HashMap<String, String>();

    public RecoveryKeyContext(String connectionKey, long msgSerial, Map<String, String> channelSerials) {
        this.connectionKey = connectionKey;
        this.msgSerial = msgSerial;
        this.channelSerials.putAll(channelSerials);
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public long getMsgSerial() {
        return this.msgSerial;
    }

    public Map<String, String> getChannelSerials() {
        return this.channelSerials;
    }

    public String encode() {
        return Serialisation.gson.toJson(this);
    }

    public static RecoveryKeyContext decode(String json) {
        try {
            return Serialisation.gson.fromJson(json, RecoveryKeyContext.class);
        }
        catch (JsonSyntaxException e2) {
            Log.e(TAG, "Cannot create recovery key from json: " + e2.getMessage());
            return null;
        }
    }
}

