/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.network.FailedConnectionException;
import io.ably.lib.types.ErrorInfo;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class AblyException
extends Exception {
    private static final long serialVersionUID = -3804072091596832634L;
    public ErrorInfo errorInfo;

    protected AblyException(Throwable throwable, ErrorInfo reason) {
        super(throwable);
        this.errorInfo = reason;
    }

    public static AblyException fromErrorInfo(ErrorInfo errorInfo) {
        return AblyException.fromErrorInfo(new Exception(errorInfo.message), errorInfo);
    }

    public static AblyException fromErrorInfo(Throwable t2, ErrorInfo errorInfo) {
        if (errorInfo.statusCode >= 500 && errorInfo.statusCode <= 504) {
            return new HostFailedException(t2, errorInfo);
        }
        return new AblyException(t2, errorInfo);
    }

    public static AblyException fromThrowable(Throwable t2) {
        if (t2 instanceof AblyException) {
            return (AblyException)t2;
        }
        if (t2 instanceof ConnectException || t2 instanceof SocketTimeoutException || t2 instanceof UnknownHostException || t2 instanceof NoRouteToHostException) {
            return new HostFailedException(t2, ErrorInfo.fromThrowable(t2));
        }
        if (t2 instanceof FailedConnectionException) {
            return new HostFailedException(t2.getCause(), ErrorInfo.fromThrowable(t2.getCause()));
        }
        return new AblyException(t2, ErrorInfo.fromThrowable(t2));
    }

    public static class HostFailedException
    extends AblyException {
        private static final long serialVersionUID = 1L;

        HostFailedException(Throwable throwable, ErrorInfo reason) {
            super(throwable, reason);
        }
    }
}

