/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.EngineType;
import io.ably.lib.network.WebSocketEngine;
import io.ably.lib.network.WebSocketEngineConfig;
import java.lang.reflect.InvocationTargetException;

public interface WebSocketEngineFactory {
    public static WebSocketEngineFactory getFirstAvailable() {
        WebSocketEngineFactory okWebSocketFactory = WebSocketEngineFactory.tryGetOkWebSocketFactory();
        if (okWebSocketFactory != null) {
            return okWebSocketFactory;
        }
        WebSocketEngineFactory defaultFactory = WebSocketEngineFactory.tryGetDefaultFactory();
        if (defaultFactory != null) {
            return defaultFactory;
        }
        throw new IllegalStateException("No engines are available");
    }

    public static WebSocketEngineFactory tryGetOkWebSocketFactory() {
        try {
            Class<?> okWebSocketFactoryClass = Class.forName("io.ably.lib.network.OkHttpWebSocketEngineFactory");
            return (WebSocketEngineFactory)okWebSocketFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            return null;
        }
    }

    public static WebSocketEngineFactory tryGetDefaultFactory() {
        try {
            Class<?> defaultFactoryClass = Class.forName("io.ably.lib.network.DefaultWebSocketEngineFactory");
            return (WebSocketEngineFactory)defaultFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            return null;
        }
    }

    public WebSocketEngine create(WebSocketEngineConfig var1);

    public EngineType getEngineType();
}

