/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.FailedConnectionException;
import io.ably.lib.network.HttpBody;
import io.ably.lib.network.HttpCall;
import io.ably.lib.network.HttpResponse;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import okhttp3.Call;
import okhttp3.Response;

public class OkHttpCall
implements HttpCall {
    private final Call call;

    public OkHttpCall(Call call) {
        this.call = call;
    }

    @Override
    public HttpResponse execute() {
        Response response = this.call.execute();
        try {
            HttpResponse httpResponse = HttpResponse.builder().headers(response.headers().toMultimap()).code(response.code()).message(response.message()).body(response.body() != null && response.body().contentType() != null ? new HttpBody(response.body().contentType().toString(), response.body().bytes()) : null).build();
            if (response != null) {
                response.close();
            }
            return httpResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ConnectException | NoRouteToHostException | SocketTimeoutException | UnknownHostException fce) {
                throw new FailedConnectionException(fce);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }
}

