/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.HttpBody;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class HttpRequest {
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    private final URL url;
    private final String method;
    private final int httpOpenTimeout;
    private final int httpReadTimeout;
    private final HttpBody body;
    private final Map<String, List<String>> headers;

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> headersCopy = new HashMap<String, List<String>>(this.headers);
        if (this.body != null) {
            int length = this.body.getContent() == null ? 0 : this.body.getContent().length;
            headersCopy.put(CONTENT_TYPE, Collections.singletonList(this.body.getContentType()));
            headersCopy.put(CONTENT_LENGTH, Collections.singletonList(Integer.toString(length)));
        }
        return headersCopy;
    }

    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public int getHttpOpenTimeout() {
        return this.httpOpenTimeout;
    }

    @Generated
    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    @Generated
    public HttpBody getBody() {
        return this.body;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHttpOpenTimeout() != other.getHttpOpenTimeout()) {
            return false;
        }
        if (this.getHttpReadTimeout() != other.getHttpReadTimeout()) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        HttpBody this$body = this.getBody();
        HttpBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHttpOpenTimeout();
        result = result * 59 + this.getHttpReadTimeout();
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        HttpBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpRequest(url=" + this.getUrl() + ", method=" + this.getMethod() + ", httpOpenTimeout=" + this.getHttpOpenTimeout() + ", httpReadTimeout=" + this.getHttpReadTimeout() + ", body=" + this.getBody() + ", headers=" + this.getHeaders() + ")";
    }

    @Generated
    public HttpRequest(URL url, String method, int httpOpenTimeout, int httpReadTimeout, HttpBody body, Map<String, List<String>> headers) {
        this.url = url;
        this.method = method;
        this.httpOpenTimeout = httpOpenTimeout;
        this.httpReadTimeout = httpReadTimeout;
        this.body = body;
        this.headers = headers;
    }

    public static class HttpRequestBuilder {
        private URL url;
        private String method;
        private int httpOpenTimeout;
        private int httpReadTimeout;
        private HttpBody body;
        private Map<String, List<String>> headers;

        HttpRequestBuilder() {
        }

        public HttpRequestBuilder url(URL url) {
            this.url = url;
            return this;
        }

        public HttpRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public HttpRequestBuilder httpOpenTimeout(int httpOpenTimeout) {
            this.httpOpenTimeout = httpOpenTimeout;
            return this;
        }

        public HttpRequestBuilder httpReadTimeout(int httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
            return this;
        }

        public HttpRequestBuilder body(HttpBody body) {
            this.body = body;
            return this;
        }

        public HttpRequestBuilder headers(Map<String, String> headers) {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                result.put(key, Collections.singletonList(value));
            }
            this.headers = Collections.unmodifiableMap(result);
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this.url, this.method, this.httpOpenTimeout, this.httpReadTimeout, this.body, this.headers);
        }

        public String toString() {
            return "HttpRequest.HttpRequestBuilder(url=" + this.url + ", method=" + this.method + ", httpOpenTimeout=" + this.httpOpenTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", body=" + this.body + ", headers=" + this.headers + ")";
        }
    }
}

