/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.EngineType;
import io.ably.lib.network.HttpEngine;
import io.ably.lib.network.HttpEngineConfig;
import java.lang.reflect.InvocationTargetException;

public interface HttpEngineFactory {
    public static HttpEngineFactory getFirstAvailable() {
        HttpEngineFactory okHttpFactory = HttpEngineFactory.tryGetOkHttpFactory();
        if (okHttpFactory != null) {
            return okHttpFactory;
        }
        HttpEngineFactory defaultFactory = HttpEngineFactory.tryGetDefaultFactory();
        if (defaultFactory != null) {
            return defaultFactory;
        }
        throw new IllegalStateException("No engines are available");
    }

    public static HttpEngineFactory tryGetOkHttpFactory() {
        try {
            Class<?> okHttpFactoryClass = Class.forName("io.ably.lib.network.OkHttpEngineFactory");
            return (HttpEngineFactory)okHttpFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            return null;
        }
    }

    public static HttpEngineFactory tryGetDefaultFactory() {
        try {
            Class<?> defaultFactoryClass = Class.forName("io.ably.lib.network.DefaultHttpEngineFactory");
            return (HttpEngineFactory)defaultFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            return null;
        }
    }

    public HttpEngine create(HttpEngineConfig var1);

    public EngineType getEngineType();
}

