/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.HttpPaginatedResponse;
import io.ably.lib.types.Param;
import io.ably.lib.util.Serialisation;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;

public class HttpPaginatedQuery
implements HttpCore.ResponseHandler<HttpPaginatedResponse> {
    static final HttpCore.BodyHandler<JsonElement> jsonArrayResponseHandler = new HttpCore.BodyHandler<JsonElement>(){

        public JsonElement[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            if (!"application/json".equals(contentType)) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected content type: " + contentType, 500, 50000));
            }
            JsonElement jsonBody = Serialisation.gsonParser.parse(new String(body, Charset.forName("UTF-8")));
            if (!jsonBody.isJsonArray()) {
                return new JsonElement[]{jsonBody};
            }
            JsonArray jsonArray = jsonBody.getAsJsonArray();
            JsonElement[] items = new JsonElement[jsonArray.size()];
            for (int i2 = 0; i2 < items.length; ++i2) {
                items[i2] = jsonArray.get(i2);
            }
            return items;
        }
    };
    private final Http http;
    private final String method;
    private final String path;
    private final Param[] requestHeaders;
    private final Param[] requestParams;
    private final HttpCore.RequestBody requestBody;
    private final HttpCore.BodyHandler<JsonElement> bodyHandler;

    public HttpPaginatedQuery(Http http, String method, String path, Param[] headers, Param[] params, HttpCore.RequestBody requestBody) {
        this.http = http;
        this.method = method;
        this.path = path;
        this.requestHeaders = headers;
        this.requestParams = params;
        this.requestBody = requestBody;
        this.bodyHandler = jsonArrayResponseHandler;
    }

    public HttpPaginatedResponse exec() throws AblyException {
        return this.exec(this.requestParams);
    }

    public HttpPaginatedResponse exec(final Param[] params) throws AblyException {
        final HttpPaginatedQuery responseHandler = this;
        return this.http.request(new Http.Execute<HttpPaginatedResponse>(){

            @Override
            public void execute(HttpScheduler http, Callback<HttpPaginatedResponse> callback) throws AblyException {
                http.exec(HttpPaginatedQuery.this.path, HttpPaginatedQuery.this.method, HttpPaginatedQuery.this.requestHeaders, params, HttpPaginatedQuery.this.requestBody, responseHandler, true, callback);
            }
        }).sync();
    }

    @Override
    public HttpPaginatedResponse handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
        return new HttpPaginatedResult(response, error);
    }

    public class HttpPaginatedResult
    extends HttpPaginatedResponse {
        private JsonElement[] contents;
        private String relFirst;
        private String relCurrent;
        private String relNext;

        private HttpPaginatedResult(HttpCore.Response response, ErrorInfo error) throws AblyException {
            this.statusCode = response.statusCode;
            this.headers = HttpUtils.toParamArray(response.headers);
            if (error != null) {
                this.errorCode = error.code;
                this.errorMessage = error.message;
            } else {
                this.success = true;
                if (response.body != null) {
                    this.contents = (JsonElement[])HttpPaginatedQuery.this.bodyHandler.handleResponseBody(response.contentType, response.body);
                }
            }
            List<String> linkHeaders = response.getHeaderFields("Link");
            if (linkHeaders != null) {
                HashMap<String, String> links = BasePaginatedQuery.parseLinks(linkHeaders);
                this.relFirst = links.get("first");
                this.relCurrent = links.get("current");
                this.relNext = links.get("next");
            }
        }

        @Override
        public JsonElement[] items() {
            return this.contents;
        }

        @Override
        public HttpPaginatedResponse first() throws AblyException {
            return this.execRel(this.relFirst);
        }

        @Override
        public HttpPaginatedResponse current() throws AblyException {
            return this.execRel(this.relCurrent);
        }

        @Override
        public HttpPaginatedResponse next() throws AblyException {
            return this.execRel(this.relNext);
        }

        private HttpPaginatedResponse execRel(String linkUrl) throws AblyException {
            if (linkUrl == null) {
                return null;
            }
            Matcher urlMatch = BasePaginatedQuery.urlPattern.matcher(linkUrl);
            if (urlMatch.matches()) {
                String[] paramSpecs = urlMatch.group(2).split("&");
                Param[] params = new Param[paramSpecs.length];
                try {
                    for (int i2 = 0; i2 < paramSpecs.length; ++i2) {
                        String[] split = paramSpecs[i2].split("=");
                        String paramKey = split[0];
                        String paramValue = split.length >= 2 ? split[1] : "";
                        params[i2] = new Param(paramKey, URLDecoder.decode(paramValue, "UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                return HttpPaginatedQuery.this.exec(params);
            }
            throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected link URL format", 500, 50000));
        }

        @Override
        public boolean hasFirst() {
            return this.relFirst != null;
        }

        @Override
        public boolean hasCurrent() {
            return this.relCurrent != null;
        }

        @Override
        public boolean hasNext() {
            return this.relNext != null;
        }

        @Override
        public boolean isLast() {
            return this.relNext == null;
        }
    }
}

