/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import java.net.URL;

public class HttpHelpers {
    private static final String TAG = HttpHelpers.class.getName();

    public static <T> T ablyHttpExecute(Http http, final String path, final String method, final Param[] headers, final Param[] params, final HttpCore.RequestBody requestBody, final HttpCore.ResponseHandler<T> responseHandler, final boolean requireAblyAuth) throws AblyException {
        return (T)http.request(new Http.Execute<T>(){

            @Override
            public void execute(HttpScheduler http, Callback<T> callback) throws AblyException {
                http.exec(path, method, headers, params, requestBody, responseHandler, requireAblyAuth, callback);
            }
        }).sync();
    }

    public static String getUrlString(HttpCore httpCore, String url) throws AblyException {
        byte[] bytes = HttpHelpers.getUrl(httpCore, url);
        if (bytes == null) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Empty response body", 500, 50000));
        }
        return new String(bytes);
    }

    public static byte[] getUrl(HttpCore httpCore, String url) throws AblyException {
        try {
            return HttpHelpers.httpExecute(httpCore, new URL(url), "GET", null, null, new HttpCore.ResponseHandler<byte[]>(){

                @Override
                public byte[] handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
                    if (error != null) {
                        throw AblyException.fromErrorInfo(error);
                    }
                    return response.body;
                }
            });
        }
        catch (Exception e2) {
            throw AblyException.fromThrowable(e2);
        }
    }

    public static <T> T getUri(HttpCore httpCore, String uri, Param[] headers, Param[] params, HttpCore.ResponseHandler<T> responseHandler) throws AblyException {
        return HttpHelpers.httpExecute(httpCore, HttpUtils.buildURL(uri, params), "GET", headers, null, responseHandler);
    }

    public static <T> T postUri(HttpCore httpCore, String uri, Param[] headers, Param[] queryParams, Param[] bodyParams, HttpCore.ResponseHandler<T> responseHandler) throws AblyException {
        return HttpHelpers.httpExecute(httpCore, HttpUtils.buildURL(uri, queryParams), "POST", headers, new HttpUtils.FormRequestBody(bodyParams), responseHandler);
    }

    public static <T> T httpExecute(HttpCore httpCore, URL url, String method, Param[] headers, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler) throws AblyException {
        return httpCore.httpExecuteWithRetry(url, method, headers, requestBody, responseHandler, false);
    }

    public static <T> T postSync(Http http, final String path, final Param[] headers, final Param[] params, final HttpCore.RequestBody requestBody, final HttpCore.ResponseHandler<T> responseHandler, final boolean requireAblyAuth) throws AblyException {
        return (T)http.request(new Http.Execute<T>(){

            @Override
            public void execute(HttpScheduler http, Callback<T> callback) throws AblyException {
                http.post(path, headers, params, requestBody, responseHandler, requireAblyAuth, callback);
            }
        }).sync();
    }
}

