/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class Closer
implements Closeable {
    @VisibleForTesting
    final Suppressor suppressor;
    private final Deque<Closeable> stack = new ArrayDeque<Closeable>(4);
    @CheckForNull
    private Throwable thrown;
    private static final Suppressor SUPPRESSING_SUPPRESSOR = (closeable, thrown, suppressed) -> {
        if (thrown == suppressed) {
            return;
        }
        try {
            thrown.addSuppressed(suppressed);
        }
        catch (Throwable e2) {
            Closeables.logger.log(Level.WARNING, "Suppressing exception thrown when closing " + closeable, suppressed);
        }
    };

    public static Closer create() {
        return new Closer(SUPPRESSING_SUPPRESSOR);
    }

    @VisibleForTesting
    Closer(Suppressor suppressor) {
        this.suppressor = Preconditions.checkNotNull(suppressor);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public <C extends Closeable> C register(@ParametricNullness C closeable) {
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
        return closeable;
    }

    public RuntimeException rethrow(Throwable e2) throws IOException {
        Preconditions.checkNotNull(e2);
        this.thrown = e2;
        Throwables.throwIfInstanceOf(e2, IOException.class);
        Throwables.throwIfUnchecked(e2);
        throw new RuntimeException(e2);
    }

    public <X extends Exception> RuntimeException rethrow(Throwable e2, Class<X> declaredType) throws IOException, X {
        Preconditions.checkNotNull(e2);
        this.thrown = e2;
        Throwables.throwIfInstanceOf(e2, IOException.class);
        Throwables.throwIfInstanceOf(e2, declaredType);
        Throwables.throwIfUnchecked(e2);
        throw new RuntimeException(e2);
    }

    public <X1 extends Exception, X2 extends Exception> RuntimeException rethrow(Throwable e2, Class<X1> declaredType1, Class<X2> declaredType2) throws IOException, X1, X2 {
        Preconditions.checkNotNull(e2);
        this.thrown = e2;
        Throwables.throwIfInstanceOf(e2, IOException.class);
        Throwables.throwIfInstanceOf(e2, declaredType1);
        Throwables.throwIfInstanceOf(e2, declaredType2);
        Throwables.throwIfUnchecked(e2);
        throw new RuntimeException(e2);
    }

    @Override
    public void close() throws IOException {
        Throwable throwable = this.thrown;
        while (!this.stack.isEmpty()) {
            Closeable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable e2) {
                if (throwable == null) {
                    throwable = e2;
                    continue;
                }
                this.suppressor.suppress(closeable, throwable, e2);
            }
        }
        if (this.thrown == null && throwable != null) {
            Throwables.throwIfInstanceOf(throwable, IOException.class);
            Throwables.throwIfUnchecked(throwable);
            throw new AssertionError((Object)throwable);
        }
    }

    @VisibleForTesting
    static interface Suppressor {
        public void suppress(Closeable var1, Throwable var2, Throwable var3);
    }
}

