/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.engine.VCDiffCodeTableData;
import com.davidehrmann.vcdiff.engine.VCDiffCodeTableReader;
import com.davidehrmann.vcdiff.engine.VCDiffHeaderParser;
import com.davidehrmann.vcdiff.engine.VCDiffStreamingDecoderImpl;
import com.davidehrmann.vcdiff.util.Objects;
import com.davidehrmann.vcdiff.util.VarInt;
import com.davidehrmann.vcdiff.util.ZeroInitializedAdler32;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Adler32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VCDiffDeltaFileWindow {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCDiffDeltaFileWindow.class);
    private final VCDiffStreamingDecoderImpl parent;
    private boolean foundHeader;
    private ByteBuffer sourceSegment;
    private final AtomicInteger sourceSegmentLength = new AtomicInteger(0);
    private ByteBuffer instructionsAndSizes;
    private ByteBuffer dataForAddAndRun;
    private ByteBuffer addressesForCopy;
    private int interleavedBytesExpected;
    private Integer targetWindowLength;
    private int targetWindowStartPos;
    private boolean hasChecksum;
    private final AtomicInteger expectedChecksum = new AtomicInteger(0);
    private final Adler32 adler32 = new ZeroInitializedAdler32();
    private VCDiffCodeTableReader reader = new VCDiffCodeTableReader();

    public VCDiffDeltaFileWindow(VCDiffStreamingDecoderImpl parent) {
        this.parent = Objects.requireNotNull(parent, "parent was null");
        this.Reset();
    }

    public void Reset() {
        this.foundHeader = false;
        this.targetWindowStartPos = this.parent != null ? this.parent.decodedTarget().size() : 0;
        this.targetWindowLength = 0;
        this.sourceSegment = null;
        this.sourceSegmentLength.set(0);
        this.instructionsAndSizes = null;
        this.dataForAddAndRun = null;
        this.addressesForCopy = null;
        this.interleavedBytesExpected = 0;
        this.hasChecksum = false;
        this.expectedChecksum.set(0);
    }

    public void useCodeTable(VCDiffCodeTableData code_table_data, short max_mode) {
        this.reader = new VCDiffCodeTableReader(code_table_data, max_mode);
    }

    public int DecodeWindow(ByteBuffer parseable_chunk) throws IOException {
        if (!this.foundHeader) {
            if (this.readHeader(parseable_chunk) == -2) {
                return -2;
            }
            this.parent.addrCache().Init();
        } else {
            if (!this.isInterleaved()) {
                throw new IOException("Internal error: Resumed decoding of a delta file window when interleaved format is not being used");
            }
            this.updateInterleavedSectionPointers(parseable_chunk);
            this.reader.updatePointers(this.instructionsAndSizes);
        }
        switch (this.decodeBody(parseable_chunk)) {
            case -2: {
                if (this.moreDataExpected()) {
                    return -2;
                }
                throw new IOException("End of data reached while decoding VCDIFF delta file");
            }
        }
        this.Reset();
        return 0;
    }

    public boolean FoundWindowHeader() {
        return this.foundHeader;
    }

    public boolean moreDataExpected() {
        return this.isInterleaved() && this.interleavedBytesExpected > 0;
    }

    public int targetWindowStartPos() {
        return this.targetWindowStartPos;
    }

    public void setTargetWindowStartPos(int new_start_pos) {
        this.targetWindowStartPos = new_start_pos;
    }

    public int targetBytesRemaining() {
        if (this.targetWindowLength == 0) {
            return 0;
        }
        return this.targetWindowLength - this.targetBytesDecoded();
    }

    private int readHeader(ByteBuffer parseableChunk) throws IOException {
        VCDiffStreamingDecoderImpl.DecoratedByteArrayOutputStream decoded_target = this.parent.decodedTarget();
        VCDiffHeaderParser header_parser = new VCDiffHeaderParser(parseableChunk.slice());
        VCDiffHeaderParser.DeltaWindowHeader deltaWindowHeader = header_parser.parseWinIndicatorAndSourceSegment(this.parent.dictionary_ptr().limit(), decoded_target.size(), this.parent.allowVcdTarget());
        if (deltaWindowHeader == null) {
            return header_parser.getResult();
        }
        this.sourceSegmentLength.set(deltaWindowHeader.source_segment_length);
        this.hasChecksum = this.parent.allowChecksum() && (deltaWindowHeader.win_indicator & 4) != 0;
        this.targetWindowLength = header_parser.ParseWindowLengths();
        if (this.targetWindowLength == null) {
            return header_parser.getResult();
        }
        this.parent.targetWindowWouldExceedSizeLimits(this.targetWindowLength);
        header_parser.parseDeltaIndicator();
        int setup_return_code = this.setUpWindowSections(header_parser);
        if (0 != setup_return_code) {
            return setup_return_code;
        }
        if ((deltaWindowHeader.win_indicator & 1) != 0) {
            this.sourceSegment = (ByteBuffer)this.parent.dictionary_ptr().duplicate().rewind();
            this.sourceSegment.position(deltaWindowHeader.source_segment_position);
        } else if ((deltaWindowHeader.win_indicator & 2) != 0) {
            this.sourceSegment = decoded_target.toByteBuffer();
            this.sourceSegment.position(deltaWindowHeader.source_segment_position);
        }
        this.foundHeader = true;
        parseableChunk.position(parseableChunk.position() + header_parser.unparsedData().position());
        this.parent.addToTotalTargetWindowSize(this.targetWindowLength);
        return 0;
    }

    private int setUpWindowSections(VCDiffHeaderParser header_parser) throws IOException {
        VCDiffHeaderParser.SectionLengths sectionLengths = header_parser.parseSectionLengths(this.hasChecksum);
        if (sectionLengths == null) {
            return header_parser.getResult();
        }
        int parsed_delta_encoding_length = VarInt.calculateIntLength(this.targetWindowLength) + 1 + VarInt.calculateIntLength(sectionLengths.add_and_run_data_length) + VarInt.calculateIntLength(sectionLengths.addresses_length) + VarInt.calculateIntLength(sectionLengths.instructions_and_sizes_length) + sectionLengths.add_and_run_data_length + sectionLengths.addresses_length + sectionLengths.instructions_and_sizes_length;
        if (this.hasChecksum) {
            this.expectedChecksum.set(sectionLengths.checksum);
            parsed_delta_encoding_length += VarInt.calculateIntLength(sectionLengths.checksum);
        }
        if (this.parent.allowInterleaved() && sectionLengths.add_and_run_data_length == 0 && sectionLengths.addresses_length == 0) {
            this.interleavedBytesExpected = sectionLengths.instructions_and_sizes_length;
            this.updateInterleavedSectionPointers(header_parser.unparsedData());
        } else {
            if (header_parser.unparsedData().remaining() < sectionLengths.add_and_run_data_length + sectionLengths.instructions_and_sizes_length + sectionLengths.addresses_length) {
                return -2;
            }
            this.dataForAddAndRun = header_parser.unparsedData().slice();
            this.dataForAddAndRun.position(sectionLengths.add_and_run_data_length);
            this.instructionsAndSizes = this.dataForAddAndRun.slice();
            this.instructionsAndSizes.position(sectionLengths.instructions_and_sizes_length);
            this.addressesForCopy = this.instructionsAndSizes.slice();
            this.addressesForCopy.position(sectionLengths.addresses_length);
            this.dataForAddAndRun.flip();
            this.instructionsAndSizes.flip();
            this.addressesForCopy.flip();
            if (header_parser.deltaEncodingLength != parsed_delta_encoding_length) {
                throw new IOException("The end of the instructions section does not match the end of the delta window");
            }
        }
        this.reader.init(this.instructionsAndSizes);
        return 0;
    }

    private int decodeBody(ByteBuffer parseable_chunk) throws IOException {
        if (this.isInterleaved()) {
            // empty if block
        }
        while (this.targetBytesDecoded() < this.targetWindowLength) {
            int result;
            AtomicInteger decoded_size = new AtomicInteger(0);
            AtomicInteger mode = new AtomicInteger(0);
            byte instruction = this.reader.getNextInstruction(decoded_size, mode);
            switch (instruction) {
                case 5: {
                    this.updateInstructionPointer(parseable_chunk);
                    return -2;
                }
            }
            int size = decoded_size.get();
            if (size > this.targetWindowLength || size + this.targetBytesDecoded() > this.targetWindowLength) {
                throw new IOException(String.format("%s with size %d plus existing %d bytes of target data exceeds length of target window (%d bytes)", VCDiffCodeTableData.VCDiffInstructionName(instruction), size, this.targetBytesDecoded(), this.targetWindowLength));
            }
            switch (instruction) {
                case 1: {
                    result = this.decodeAdd(size);
                    break;
                }
                case 2: {
                    result = this.decodeRun(size);
                    break;
                }
                case 3: {
                    result = this.decodeCopy(size, (short)mode.get());
                    break;
                }
                default: {
                    throw new IOException("Unexpected instruction type " + instruction + " in opcode stream");
                }
            }
            switch (result) {
                case -2: {
                    this.reader.unGetInstruction();
                    this.updateInstructionPointer(parseable_chunk);
                    return -2;
                }
            }
        }
        if (this.targetBytesDecoded() != this.targetWindowLength.intValue()) {
            throw new IOException(String.format("Decoded target window size (%d bytes) does not match expected size (%d bytes)", this.targetBytesDecoded(), this.targetWindowLength));
        }
        if (this.hasChecksum) {
            this.adler32.update(this.parent.decodedTarget().getBuffer(), this.targetWindowStartPos, this.targetWindowLength);
            int checksum = (int)this.adler32.getValue();
            this.adler32.reset();
            if (checksum != this.expectedChecksum.get()) {
                throw new IOException("Target data does not match checksum; this could mean that the wrong dictionary was used");
            }
        }
        if (this.instructionsAndSizes.hasRemaining()) {
            throw new IOException("Excess instructions and sizes left over after decoding target window");
        }
        if (!this.isInterleaved()) {
            if (this.dataForAddAndRun.hasRemaining()) {
                throw new IOException("Excess ADD/RUN data left over after decoding target window");
            }
            if (this.addressesForCopy.hasRemaining()) {
                throw new IOException("Excess COPY addresses left over after decoding target window");
            }
            parseable_chunk.position(parseable_chunk.position() + this.instructionsAndSizes.limit() + this.dataForAddAndRun.limit() + this.addressesForCopy.limit());
        } else {
            this.updateInstructionPointer(parseable_chunk);
        }
        return 0;
    }

    private int targetBytesDecoded() {
        return this.parent.decodedTarget().size() - this.targetWindowStartPos;
    }

    private int decodeAdd(int size) {
        if (size > this.dataForAddAndRun.remaining()) {
            return -2;
        }
        this.copyBytes(this.dataForAddAndRun, size);
        return 0;
    }

    private int decodeRun(int size) {
        if (!this.dataForAddAndRun.hasRemaining()) {
            return -2;
        }
        this.runByte(this.dataForAddAndRun.get(), size);
        return 0;
    }

    private int decodeCopy(int size, short mode) throws IOException {
        int decodedAddress;
        int target_bytes_decoded = this.targetBytesDecoded();
        int here_address = this.sourceSegmentLength.get() + target_bytes_decoded;
        try {
            decodedAddress = this.parent.addrCache().DecodeAddress(here_address, mode, this.addressesForCopy);
        }
        catch (IOException e2) {
            IOException rethrown = new IOException("Unable to decode address for COPY");
            rethrown.initCause(e2);
            throw e2;
        }
        if (decodedAddress == -2) {
            return -2;
        }
        if (decodedAddress < 0 || decodedAddress > here_address) {
            throw new IllegalStateException(String.format("Internal error: unexpected address %d returned from DecodeAddress, with here_address = %d", decodedAddress, here_address));
        }
        int address = decodedAddress;
        if (address + size <= this.sourceSegmentLength.get()) {
            this.copyBytes((ByteBuffer)this.sourceSegment.slice().position(address), size);
            return 0;
        }
        if (address < this.sourceSegmentLength.get()) {
            int partial_copy_size = this.sourceSegmentLength.get() - address;
            this.copyBytes((ByteBuffer)this.sourceSegment.slice().position(address), partial_copy_size);
            target_bytes_decoded += partial_copy_size;
            address += partial_copy_size;
            size -= partial_copy_size;
        }
        address -= this.sourceSegmentLength.get();
        ByteBuffer targetSegment = this.parent.decodedTarget().toByteBuffer();
        targetSegment.position(this.targetWindowStartPos);
        while (size > target_bytes_decoded - address) {
            int partial_copy_size = target_bytes_decoded - address;
            this.copyBytes((ByteBuffer)targetSegment.slice().position(address), partial_copy_size);
            target_bytes_decoded += partial_copy_size;
            address += partial_copy_size;
            size -= partial_copy_size;
            targetSegment = this.parent.decodedTarget().toByteBuffer();
            targetSegment.position(this.targetWindowStartPos);
        }
        this.copyBytes((ByteBuffer)targetSegment.slice().position(address), size);
        return 0;
    }

    private void updateInterleavedSectionPointers(ByteBuffer data) {
        this.instructionsAndSizes = data.slice();
        if (this.instructionsAndSizes.remaining() > this.interleavedBytesExpected) {
            this.instructionsAndSizes.limit(this.interleavedBytesExpected);
        }
        this.dataForAddAndRun = this.instructionsAndSizes;
        this.addressesForCopy = this.instructionsAndSizes;
    }

    private boolean isInterleaved() {
        return this.addressesForCopy == this.instructionsAndSizes && this.dataForAddAndRun == this.instructionsAndSizes;
    }

    private void copyBytes(ByteBuffer buffer, int size) {
        while (size-- > 0) {
            this.parent.decodedTarget().write(buffer.get());
        }
    }

    private void runByte(byte b2, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            this.parent.decodedTarget().write(b2);
        }
    }

    private void updateInstructionPointer(ByteBuffer parseableChunk) {
        if (this.isInterleaved()) {
            int bytes_parsed = this.instructionsAndSizes.position();
            this.interleavedBytesExpected -= bytes_parsed;
            parseableChunk.position(parseableChunk.position() + bytes_parsed);
        }
    }
}

