/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.VCDiffCodeTableWriter;
import com.davidehrmann.vcdiff.VCDiffFormatExtension;
import java.io.IOException;
import java.util.EnumSet;

public class JSONCodeTableWriter
implements VCDiffCodeTableWriter<Appendable> {
    private StringBuilder output = new StringBuilder(1024);
    private boolean outputCalled = false;
    private boolean opcodeAdded = false;

    @Override
    public void init(int dictionarySize) {
        this.output.append('[');
        this.opcodeAdded = false;
    }

    @Override
    public void add(byte[] data, int offset, int length) {
        if (offset < 0 || offset + length > data.length) {
            throw new IllegalArgumentException();
        }
        if (this.opcodeAdded) {
            this.output.append(',');
        }
        this.output.append('\"');
        for (int i2 = offset; i2 < offset + length; ++i2) {
            JSONCodeTableWriter.JSONEscape(data[i2], this.output);
        }
        this.output.append('\"');
        this.opcodeAdded = true;
    }

    @Override
    public void addChecksum(int checksum) {
        throw new UnsupportedOperationException("Checksum not supported");
    }

    @Override
    public void copy(int offset, int size) {
        if (this.opcodeAdded) {
            this.output.append(',');
        }
        this.output.append(offset);
        this.output.append(',');
        this.output.append(size);
        this.opcodeAdded = true;
    }

    @Override
    public void finishEncoding(Appendable out) throws IOException {
        if (this.outputCalled) {
            out.append(']');
        }
    }

    @Override
    public void output(Appendable out) throws IOException {
        this.outputCalled = true;
        out.append(this.output);
        this.output = new StringBuilder(1024);
    }

    @Override
    public void run(int size, byte b2) {
        if (this.opcodeAdded) {
            this.output.append(',');
        }
        this.output.append('\"');
        StringBuilder escapedByte = new StringBuilder(8);
        JSONCodeTableWriter.JSONEscape(b2, escapedByte);
        for (int i2 = 0; i2 < size; ++i2) {
            this.output.append((CharSequence)escapedByte);
        }
        this.output.append('\"');
        this.opcodeAdded = true;
    }

    @Override
    public void writeHeader(Appendable out, EnumSet<VCDiffFormatExtension> formatExtensions) throws IOException {
        if (!formatExtensions.isEmpty() && !EnumSet.of(VCDiffFormatExtension.GOOGLE_JSON).equals(formatExtensions)) {
            throw new IOException("VCDiffFormatExtensions " + formatExtensions + " no compatible with JSONCodeTableWritar");
        }
    }

    private static void JSONEscape(byte b2, StringBuilder out) {
        switch (b2) {
            case 34: {
                out.append("\\\"");
                break;
            }
            case 92: {
                out.append("\\\\");
                break;
            }
            case 8: {
                out.append("\\b");
                break;
            }
            case 12: {
                out.append("\\f");
                break;
            }
            case 10: {
                out.append("\\n");
                break;
            }
            case 13: {
                out.append("\\r");
                break;
            }
            case 9: {
                out.append("\\t");
                break;
            }
            default: {
                if (b2 < 32 || b2 >= 127) {
                    out.append(String.format("\\u%04x", b2 & 0xFFFF));
                    break;
                }
                out.append((char)b2);
            }
        }
    }
}

