/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.collab.platform.msgfeed.Utils;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogUtils {
    public static void updateLog4JConfigForPlugin(String printPattern, String fileName, String basePackage, Level level, String logFileIdentifier) {
        String filePattern = "logs/$${date:yyyy-MM}/" + fileName + "-%d{MM-dd-yyyy}-%i.log.gz";
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        Map existingLoggerMap = config.getLoggers();
        if (existingLoggerMap.get(basePackage) != null) {
            config.removeLogger(basePackage);
        }
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withMax("7").withMin("1").withFileIndex("max").withConfig(config).withCompressionLevelStr("0").build();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(printPattern).build();
        RollingFileAppender.Builder builder = RollingFileAppender.newBuilder();
        builder.withFileName("logs/" + fileName + ".log");
        builder.withFilePattern(filePattern);
        builder.withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)"50MB"));
        builder.withStrategy((RolloverStrategy)strategy);
        builder.setLayout((Layout)layout);
        builder.setName(logFileIdentifier);
        builder.setConfiguration(config);
        RollingFileAppender raf = builder.build();
        raf.start();
        config.addAppender((Appender)raf);
        LoggerConfig loggerConfig = new LoggerConfig(logFileIdentifier, level, false);
        loggerConfig.addAppender((Appender)raf, null, null);
        config.addLogger(basePackage, loggerConfig);
        ctx.updateLoggers();
    }
}

